VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "IniFiles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'------------------------------------------------------------------
' Name : IniFile
'
' Purpose : Purpose an interface to access to Ini Files
'
' Methods :
'    1) CloseFile           Close the Ini File
'    2) GetValue            Read one value of the file
'    3) OpenFile            Open an Ini File
'    4) SaveFile            Save the Ini File
'    5) SetValue            Change a Value (can create a new section)
'    6) Property FileName   Read/Change the path and name of the ini file
'
' review : 21/Apr/2000 by Alexandre Delavanne
'------------------------------------------------------------------

Dim ms_File As String
Dim ml_FileNumber As Long

Dim ml_SectionsNumber As Long
Dim mo_Sections() As String
Dim mo_Keys() As Collection
Dim mo_Values() As Collection

Dim mb_isCrypted As Boolean

Private Declare Function GetTempFileName Lib "Kernel32" Alias "GetTempFileNameA" (ByVal lpszPath As String, ByVal lpPrefixString As String, ByVal wUnique As Long, ByVal lpTempFilename As String) As Long

Private Function GetTempName(ls_Rep As String, ls_TmpFilePrefix As String, ls_FileName As String) As Boolean
'------------------------------------------------------------------
' Name : GetTempName
'
' Purpose : Return a temporary name
'
' Parameters :
'   ls_rep              Directory where you want to create a temporary file
'   ls_TmpFilePrefix    Prefixe of the temporary file to create
'   ls_Filename         Name of the created file
'
' Return :
'       OK if success or KO
'
' review : Mar/28/2000 by AD
'------------------------------------------------------------------
Dim ls_TempFileName As String * 256
Dim ls_tempStr As String
Dim ls_DriveName As String
Dim li_pos As Integer
Dim li_CurrPos As Integer
Dim li_StartPos As Integer

    GetTempName = False
    
    ls_FileName = ""
    
    On Error GoTo GetTempName_Err

    ls_DriveName = ls_Rep
    'Ask the temporary name to Windows
    If GetTempFileName(ls_DriveName, ls_TmpFilePrefix, 0, ls_TempFileName) = False Then
        'Windows cannot create a temporary file
        Exit Function
    End If
    
    'Read the temporary String
    ls_tempStr = Left$(ls_TempFileName, InStr(ls_TempFileName, Chr(0)) - 1)
    
    'Find the last backshlash
    li_CurrPos = 0
    li_StartPos = 1
    li_pos = InStr(li_StartPos, ls_tempStr, "\", vbBinaryCompare)
    Do While li_pos > 0
        li_CurrPos = li_pos
        li_StartPos = li_pos + 1
        li_pos = InStr(li_StartPos, ls_tempStr, "\", vbBinaryCompare)
    Loop
    
    'Read the filename
    ls_FileName = Right(ls_tempStr, Len(ls_tempStr) - li_CurrPos)
    
    GetTempName = True
    
    Exit Function
    
GetTempName_Err:

End Function

Private Function ExtractPath(ls_FileName As String) As String
'------------------------------------------------------------------
' Name : ExtractPath (Private)
'
' Purpose : Extract the path of a file from the string
'
' Parameters :
'       ls_FileName     the path + filename
'
' Return : The path
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ls_Path As String
Dim li_CurrPos As Integer
Dim li_StartPos As Integer
Dim li_pos As Integer

    ExtractPath = ""
    
    On Error GoTo ExtractPath_Err
    
    'Read the path
    li_CurrPos = 0
    li_StartPos = 1
    li_pos = InStr(li_StartPos, ls_FileName, "\", vbBinaryCompare)
    Do While li_pos > 0
        li_CurrPos = li_pos
        li_StartPos = li_pos + 1
        li_pos = InStr(li_StartPos, ls_FileName, "\", vbBinaryCompare)
    Loop
    ExtractPath = Mid(ls_FileName, 1, li_CurrPos)

    Exit Function
    
ExtractPath_Err:

End Function

Public Property Get FileName() As String
'------------------------------------------------------------------
' Name : FileName (Get)
'
' Purpose : Return the Path + Name of the Ini File
'
' Parameters : None
'
' Return : The Path + Name
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------

    FileName = ms_File

End Property

Public Property Let FileName(ls_FileName As String)
'------------------------------------------------------------------
' Name : FileName (Let)
'
' Purpose : Change the Path + Name of the Ini File
'
' Parameters :
'       ls_FileName     The new Path + Name
'
' Return : None
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------

    ms_File = ls_FileName

End Property

Public Property Get IsCrypted() As Boolean
    IsCrypted = mb_isCrypted

End Property

Public Property Let IsCrypted(value As Boolean)
    mb_isCrypted = value

End Property

Public Function OpenFile() As Boolean
'------------------------------------------------------------------
' Name : OpenFile
'
' Purpose : Open the Ini File and read it
'
' Parameters : None
'
' Return : True if it was OK otherwise False
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------
Dim ls_Text As Variant
Dim ls_Value As Variant
Dim lb_Result As Boolean
Dim ll_position As Long
Dim ll_keyNumber As Long

    OpenFile = False
    
    On Error GoTo OpenFile_Err

    If ms_File = "" Then Exit Function

    ml_FileNumber = FreeFile
    Open ms_File For Input Access Read Lock Read Write As #ml_FileNumber
        
    Do While Not EOF(ml_FileNumber)
    
        ' We read the next line in the file
        Line Input #ml_FileNumber, ls_Text
        ls_Text = DecodeValue(ls_Text)
        
        'We search for a section
        If (Left(ls_Text, 1) = "[") And (Right(ls_Text, 1) = "]") Then
            'we get the new section
            lb_Result = CreateSection(Mid(ls_Text, 2, Len(ls_Text) - 2))
            If lb_Result = False Then Exit Function
        Else
            'We keep the key if it exist
            ll_position = InStr(1, ls_Text, "=", vbBinaryCompare)
            
            'We have a line and are in a section
            'We stock all lines to recreate the file correctly
            ll_keyNumber = mo_Keys(ml_SectionsNumber).Count
            If ll_position > 0 Then
                mo_Keys(ml_SectionsNumber).Add Left(ls_Text, ll_position - 1), "K" & ll_keyNumber
                ls_Value = Right(ls_Text, Len(ls_Text) - ll_position + 1)
                If Mid(ls_Value, 2, 1) = """" And Right(ls_Value, 1) = """" Then
                    ls_Value = Left(ls_Value, 1) & Mid(ls_Value, 3, Len(ls_Value) - 3)
                End If
                mo_Values(ml_SectionsNumber).Add ls_Value, "K" & ll_keyNumber
            Else
                mo_Keys(ml_SectionsNumber).Add ls_Text, "K" & ll_keyNumber
                mo_Values(ml_SectionsNumber).Add "", "K" & ll_keyNumber
            End If
        
        End If
        
    Loop
    
    OpenFile = True
    
    Exit Function
    
OpenFile_Err:

End Function

Public Function SaveFile() As Boolean
'------------------------------------------------------------------
' Name : SaveFile
'
' Purpose : Save the new Ini File
'
' Parameters : None
'
' Return : True if it was OK otherwise False
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------
Dim ls_File As String
Dim ll_FileNumber As Long
Dim i, j As Integer
Dim ls_Path As String
Dim lb_Result As Boolean

    SaveFile = False
    
    On Error GoTo SaveFile_Err

    If ms_File = "" Then Exit Function
    
    ls_Path = ExtractPath(ms_File)
    
    lb_Result = GetTempName(ls_Path, "Ini", ls_File)
    If lb_Result = False Then Exit Function
    
    ll_FileNumber = FreeFile
    Open ls_Path & ls_File For Output Access Write Lock Read Write As #ll_FileNumber
    
    For i = 0 To ml_SectionsNumber
        If mo_Keys(i).Count > 0 Then
            If mo_Sections(i) <> "" Then Print #ll_FileNumber, EncodeValue("[" & mo_Sections(i) & "]")
        
            For j = 0 To mo_Keys(i).Count - 1
                Print #ll_FileNumber, EncodeValue(mo_Keys(i).Item("K" & j) & mo_Values(i).Item("K" & j))
            Next
        End If
    Next
    
    Close #ll_FileNumber
    
    Close #ml_FileNumber
    
    FileCopy ls_Path & ls_File, ms_File
    Kill ls_Path & ls_File
    
    ml_FileNumber = FreeFile
    Open ms_File For Input Access Read Lock Read Write As #ml_FileNumber
    
    SaveFile = True
    
    Exit Function
    
SaveFile_Err:

End Function

Public Function CloseFile() As Boolean
'------------------------------------------------------------------
' Name : CloseFile
'
' Purpose : Close the current Ini File
'
' Parameters : None
'
' Return : True if it was OK otherwise False
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------

    CloseFile = False
    On Error GoTo CloseFile_Err
    
    Close #ml_FileNumber
    
    ml_FileNumber = 0
    
    CloseFile = True
    Exit Function
    
CloseFile_Err:

End Function

Private Function CreateSection(ls_Name As String) As Boolean
'------------------------------------------------------------------
' Name : CreateSection (Private)
'
' Purpose : Create a new Section in memory
'
' Parameters :
'       ls_Name     The name of the new section
'
' Return : True if it was OK otherwise False
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------

    CreateSection = False
    On Error GoTo CreateSection_Err
    
    ml_SectionsNumber = ml_SectionsNumber + 1
    ReDim Preserve mo_Sections(ml_SectionsNumber)
    ReDim Preserve mo_Keys(ml_SectionsNumber)
    ReDim Preserve mo_Values(ml_SectionsNumber)
    
    mo_Sections(ml_SectionsNumber) = ls_Name
    Set mo_Keys(ml_SectionsNumber) = New Collection
    Set mo_Values(ml_SectionsNumber) = New Collection
    
    CreateSection = True
    
    Exit Function
    
CreateSection_Err:

End Function

Private Function DeleteAllSections() As Boolean
'------------------------------------------------------------------
' Name : DeleteAllSections (Private)
'
' Purpose : Free Memory
'
' Parameters : None
'
' Return : True if it was OK otherwise False
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------
Dim i As Long
    
    DeleteAllSections = False
    On Error GoTo DeleteAllSections_Err
    
    For i = 0 To ml_SectionsNumber
        Set mo_Keys(i) = Nothing
        Set mo_Values(i) = Nothing
    Next
    
    ml_SectionsNumber = 0
    ReDim mo_Sections(ml_SectionsNumber)
    ReDim mo_Keys(ml_SectionsNumber)
    ReDim mo_Values(ml_SectionsNumber)
    
    DeleteAllSections = True
    Exit Function
    
DeleteAllSections_Err:
End Function

Public Function GetValue(ls_Section As String, ls_Key As String) As Variant
'------------------------------------------------------------------
' Name : GetValue
'
' Purpose : Get the value of one key in one section
'
' Parameters :
'       ls_Section      The section of the key
'       ls_Key          the key to read
'
' Return : The value if it exists otherwise ""
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------
Dim i, j As Integer

    GetValue = ""
    
    On Error GoTo GetValue_Err

    i = 0
    While i < ml_SectionsNumber And UCase(mo_Sections(i)) <> UCase(ls_Section)
        i = i + 1
    Wend
    
    If UCase(mo_Sections(i)) = UCase(ls_Section) Then
        j = 0
        While j < mo_Keys(i).Count - 1 And UCase(mo_Keys(i).Item("K" & j)) <> UCase(ls_Key)
            j = j + 1
        Wend
        
        If UCase(mo_Keys(i).Item("K" & j)) >= UCase(ls_Key) Then
            GetValue = Right(mo_Values(i).Item("K" & j), Len(mo_Values(i).Item("K" & j)) - 1)
        End If
    End If
    
    Exit Function

GetValue_Err:
End Function

Public Function SetValue(ls_Section As String, ls_Key As String, ls_NewValue As String) As Boolean
'------------------------------------------------------------------
' Name : SetValue
'
' Purpose : Change/Create a value in one section (can be created too)
'
' Parameters :
'       ls_Section      The Section of the Key (can be created)
'       ls_Key          The key to change/create
'       ls_Value        The value of the key
'
' Return : True if it was OK otherwise False
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------
Dim i, j As Integer
Dim ls_oldValue As String
Dim ll_keyNumber As Long

    SetValue = False
    
    On Error GoTo SetValue_Err

    i = 0
    While i < ml_SectionsNumber And UCase(mo_Sections(i)) <> UCase(ls_Section)
        i = i + 1
    Wend
    
    If UCase(mo_Sections(i)) = UCase(ls_Section) Then
        j = 0
        While j < mo_Keys(i).Count - 1 And UCase(mo_Keys(i).Item("K" & j)) <> UCase(ls_Key)
            j = j + 1
        Wend
        
        If UCase(mo_Keys(i).Item("K" & j)) = UCase(ls_Key) Then
            ls_oldValue = mo_Values(i).Item("K" & j)
            mo_Values(i).Remove "K" & j
            If Left(ls_oldValue, 1) = "=" Then
                mo_Values(i).Add "=" & ls_NewValue, "K" & j
            Else
                mo_Values(i).Add ls_NewValue, "K" & j
            End If
            SetValue = True
        End If
    End If
    
    If SetValue = False Then
        If UCase(mo_Sections(i)) <> UCase(ls_Section) Then
            CreateSection ls_Section
            i = ml_SectionsNumber
        End If
        ll_keyNumber = mo_Keys(i).Count
        mo_Keys(i).Add ls_Key, "K" & ll_keyNumber
        mo_Values(i).Add "=" & ls_NewValue, "K" & ll_keyNumber
    End If
    
    Exit Function

SetValue_Err:
End Function

'Pour l'encodage
Private Function EncodeValue(ByVal value As String) As String
    If mb_isCrypted Then
        EncodeValue = simple_coding(value)
    Else
        EncodeValue = value
    End If
    
End Function

Private Function DecodeValue(ByVal value As String) As String
    If mb_isCrypted Then
        DecodeValue = simple_decoding(value)
    Else
        DecodeValue = value
    End If
    
End Function

'-----------encodage simple
Private Function simple_coding(ByVal to_code As String)
    Dim i As Byte, wrk1 As String
    wrk1 = ""
    
    For i = 1 To Len(to_code)
        wrk1 = wrk1 & Format(Asc(Mid(to_code, i, 1)), "0##")
    Next i
    
    simple_coding = wrk1
End Function


Private Function simple_decoding(ByVal to_code As String)
    Dim i As Byte, wrk1 As String
    wrk1 = ""
    
    For i = 1 To Len(to_code) Step 3
        wrk1 = wrk1 & Chr$(Val(Mid(to_code, i, 3)))
    Next i
    
    simple_decoding = wrk1
End Function


Private Sub Class_Initialize()
'------------------------------------------------------------------
' Name : Class_Initialize
'
' Purpose : Initialize the class
'
' Parameters : None
'
' Return : None
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------
    ms_File = ""
    ml_SectionsNumber = 0
    mb_isCrypted = False
    ReDim mo_Sections(ml_SectionsNumber)
    ReDim mo_Keys(ml_SectionsNumber)
    ReDim mo_Values(ml_SectionsNumber)
    
    Set mo_Keys(ml_SectionsNumber) = New Collection
    Set mo_Values(ml_SectionsNumber) = New Collection
End Sub

Private Sub Class_Terminate()
'------------------------------------------------------------------
' Name : Class_Terminate
'
' Purpose : Terminate the class
'
' Parameters : None
'
' Return : None
'
' review : 21/Apr/2000 by AD
'------------------------------------------------------------------
    If ml_FileNumber <> 0 Then
        CloseFile
    End If
    DeleteAllSections
End Sub
